Attribute VB_Name = "mPublic"
Option Explicit

Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function SetWindowPos Lib "user32" _
                                      (ByVal hwnd As Long, _
                                       ByVal hWndInsertAfter As Long, ByVal X As Long, _
                                       ByVal Y As Long, ByVal cx As Long, _
                                       ByVal cy As Long, ByVal wFlags As Long) As Long


Public sApp As String

Public varNewData(2) As Variant
Public bNewData As Boolean

Public accApp As Access.Application
Public oConn As ADODB.Connection

Public mfrmAddIn As New frmAddIn
Public mfrmCode As New frmCode

Public Type tpField
    tpPrfix As String
    tpDeclare As String
End Type

Private Const HWND_TOPMOST = -1
Private Const HWND_NOTOPMOST = -2
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOSIZE = &H1

Public Sub URLGoTo(ByVal hwnd As Long, ByVal URL As String)
    If Len(URL) = 0 Then Exit Sub
    Screen.MousePointer = 11
    If Left$(URL, 7) <> "http://" Then URL = "http://" & URL
    Call ShellExecute(hwnd, "Open", URL, "", "", 3)
    Screen.MousePointer = 0
End Sub

' Fenster in den Vordergrund setzen
Public Sub FormOnTop(ByVal hwnd As Long, _
                     ByVal OnTop As Boolean)

    If OnTop Then
        SetWindowPos hwnd, HWND_TOPMOST, 0, 0, 0, 0, _
                     SWP_NOMOVE Or SWP_NOSIZE
    Else
        SetWindowPos hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, _
                     SWP_NOMOVE Or SWP_NOSIZE
    End If

End Sub

Sub CloseAllForms()
Dim F As Form
    On Error Resume Next
    For Each F In Forms
        Unload F
    Next
End Sub

Sub CreateCLPBBtnBmp(ResID As Long)
Dim pic As StdPicture
    Set pic = LoadResPicture(ResID, 0)
    Clipboard.SetData pic
    Set pic = Nothing
End Sub

Function fuFieldTyp(dType As Long) As tpField
    With fuFieldTyp
        Select Case dType
            Case 4: .tpDeclare = "Long": .tpPrfix = "lng"
            Case 10: .tpDeclare = "String": .tpPrfix = "str"
            Case 8: .tpDeclare = "Date": .tpPrfix = "dt"
            Case 12: .tpDeclare = "String": .tpPrfix = "str"
            Case 3: .tpDeclare = "Integer": .tpPrfix = "int"
            Case 1: .tpDeclare = "Boolean": .tpPrfix = "bln"
            Case 5: .tpDeclare = "Currency": .tpPrfix = "cur"
            Case 7: .tpDeclare = "Double": .tpPrfix = "dbl"
            Case 6: .tpDeclare = "Single": .tpPrfix = "sng"
            Case 2: .tpDeclare = "Byte": .tpPrfix = "bt"
            Case 20: .tpDeclare = "Decimal": .tpPrfix = "dec"
            Case 11: .tpDeclare = "'?LongBinary~OLE": .tpPrfix = "var"
            Case 9: .tpDeclare = "'?Binary": .tpPrfix = "var"
            Case 16: .tpDeclare = "'?BigInt": .tpPrfix = "var"
            Case 15: .tpDeclare = "'?GUID~ReplikationsID": .tpPrfix = "var"
            Case 18: .tpDeclare = "'?Char": .tpPrfix = "var"
            Case 17: .tpDeclare = "'?VarBinary": .tpPrfix = "var"
            Case 22: .tpDeclare = "'?Time": .tpPrfix = "var"
            Case 23: .tpDeclare = "'?TimeStamp": .tpPrfix = "var"
            Case 19: .tpDeclare = "'?Numeric": .tpPrfix = "var"
            Case Else
                .tpDeclare = "Variant"
                .tpPrfix = "var"
        End Select
    End With
End Function

Function ParseSQL(sSQL As String) As String
Dim iPos As Long
Dim sTmp As String

    On Error Resume Next
    sTmp = sSQL
    'sTmp = Replace(sSQL, vbCrLf, "")
    sTmp = Replace(sTmp, ",", vbCrLf & CodeIndent & ",")
    sTmp = Replace(sTmp, "From", vbCrLf & "From")
    sTmp = Replace(sTmp, "Having", vbCrLf & "Having")
    sTmp = Replace(sTmp, "Group", vbCrLf & "Group")
    sTmp = Replace(sTmp, "Where", vbCrLf & "Where")
    sTmp = Replace(sTmp, "Order", vbCrLf & "Order")

    ParseSQL = sTmp

End Function

Function CodeIndent(Optional Indent As Long = 5) As String
Dim L As Long
    CodeIndent = String(Indent, " ")
End Function

Public Function fuPopup()
Dim oVBE As VBE
Dim cp As CodeModule
Dim l1 As Long, l2 As Long, c1 As Long, c2 As Long, lTyp As Long
Dim sLine As String


    If accApp Is Nothing Then
        Set accApp = CreateObject(sApp)
        If accApp Is Nothing Then
            MsgBox "Fehler - AccessObject konnte initialisiert werden!", , "Error", , , , True
            Exit Function
        End If
    End If

    On Error Resume Next
    Unload mfrmCode
    Set mfrmCode = Nothing
    On Error GoTo 0

    On Error GoTo Fehler

    Set oVBE = accApp.VBE
    Set cp = oVBE.ActiveCodePane.CodeModule

    oVBE.ActiveCodePane.GetSelection l1, c1, l2, c2
    sLine = cp.Lines(l1, l2 - l1 + 1)

    If Len(sLine) > 0 Then
        If InStr(Left$(sLine, 16), "Sub") Then
            lTyp = 1
        ElseIf InStr(Left$(sLine, 16), "Function") Then
            lTyp = 2
        Else
            lTyp = 0
        End If
        Erase varNewData
        varNewData(0) = HoleName(sLine)
        varNewData(1) = sLine
        varNewData(2) = lTyp
        bNewData = True
    Else
        bNewData = False
    End If

    If mfrmCode Is Nothing Then
        Set mfrmCode = New frmCode
    Else

    End If
    'Load mfrmCode
    With mfrmCode
        Set .oVBE = oVBE
        Set .cp = cp
        .Show
        FormOnTop .hwnd, True
    End With

Ende:
    Set cp = Nothing
    Set oVBE = Nothing
    Exit Function

Fehler:
    MsgBox Err.Number & "(" & Err.Description & ")", , "fuPopup", , , , True
    Resume Ende

End Function

Function HoleName(sCode As String) As String
Dim sTmp As String
Dim iPos As Long


    On Error GoTo Error_Handler

    iPos = InStr(sCode, "(")

    If Left$(sCode, 3) = "Sub" Then
        sTmp = Mid(sCode, 5, iPos - 5)
    ElseIf Left$(sCode, 8) = "Function" Then
        sTmp = Mid(sCode, 10, iPos - 10)
    ElseIf Left$(sCode, 16) = "Private Function" Then
        sTmp = Mid(sCode, 18, iPos - 18)
    ElseIf Left$(sCode, 11) = "Private Sub" Then
        sTmp = Mid(sCode, 13, iPos - 13)
    ElseIf Left$(sCode, 15) = "Public Function" Then
        sTmp = Mid(sCode, 17, iPos - 17)
    ElseIf Left$(sCode, 10) = "Public Sub" Then
        sTmp = Mid(sCode, 12, iPos - 12)
    Else
        sTmp = ""
    End If

Error_Res:
    HoleName = sTmp
    On Error GoTo 0
    Exit Function

Error_Handler:
    sTmp = ""
    Resume Error_Res

End Function
