Attribute VB_Name = "mDraw"
Option Explicit

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Public Enum tCaption
    enLeft = 0
    enReight = 1
    enTop = 2
    enBottom = 3
End Enum

Dim colors1(1) As OLE_COLOR

Public Const bgOfficeBlue = &HFDCEBB
Public Const brOfficeBlue = &HB99D7F
Public Const brOfficeFocus = 12119806

Public Sub LineCtl(Con As Object, _
                   Optional Ctl As Object, _
                   Optional bDraw As Boolean = False, _
                   Optional gdDrawTyp As GradientDirection = GD_HORIZONTALLY, _
                   Optional Buttonplace As Single = 0, _
                   Optional CaptionStyle As tCaption = enLeft)
Dim bRedraw As Boolean
Dim sngLeft As Single, sngTop As Single, sngWidth As Single, sngHeight As Single

    On Error Resume Next
    With Con
        bRedraw = .AutoRedraw
        .AutoRedraw = True
        If Not Ctl Is Nothing Then
            With Ctl
                .Appearance = 0
                .BorderStyle = 0
                sngLeft = .Left - 20
                sngTop = .Top - 20
                sngWidth = .Width + 20
                sngHeight = .Height + 20
            End With

            If Buttonplace = 0 Then
                Con.Line (sngLeft, sngTop)-((sngLeft + sngWidth), (sngTop + sngHeight)), brOfficeBlue, B
            Else
                Select Case CaptionStyle
                    Case enLeft
                        Con.Line ((sngLeft - Buttonplace), sngTop)-((sngLeft + sngWidth), (sngTop + sngHeight)), brOfficeBlue, BF
                    Case enReight
                        Con.Line ((sngLeft), sngTop)-((sngLeft + sngWidth + Buttonplace), ((sngTop) + sngHeight)), brOfficeBlue, BF
                    Case enTop
                        Con.Line ((sngLeft), sngTop - Buttonplace)-((sngLeft + sngWidth), (sngTop + sngHeight)), brOfficeBlue, BF
                    Case enBottom
                        Con.Line ((sngLeft), sngTop)-((sngLeft + sngWidth), ((sngTop + Buttonplace) + sngHeight)), brOfficeBlue, BF
                End Select
            End If
            If bDraw Then DrawObject Ctl, , gdDrawTyp
        Else
            DrawObject Con, , gdDrawTyp
        End If
        .AutoRedraw = bRedraw
    End With

End Sub

Public Sub DrawObject(Con As Object, _
                      Optional gdStyle As Long = 0, _
                      Optional gdTyp As GradientDirection = GD_HORIZONTALLY)
Dim H As New cGradient
Dim r As RECT
Dim lHDC As Long
Dim bRedraw As Boolean

    On Error GoTo DrawObject_Error

    If gdStyle = 0 Then
        colors1(0) = 16105118
        colors1(1) = 16374467
    Else
        colors1(0) = 15062999
        colors1(1) = 16249586
    End If

    With Con
        r.Top = 0
        r.Bottom = .Height / Screen.TwipsPerPixelY
        r.Left = 0
        r.Right = .Width / Screen.TwipsPerPixelX
        bRedraw = .AutoRedraw
        If bRedraw = False Then .AutoRedraw = True
        lHDC = .hDC
        H.DrawGradientEx lHDC, VarPtr(r), colors1, gdTyp
        .AutoRedraw = bRedraw
    End With

DrawObject_Res:
    On Error GoTo 0
    Exit Sub

DrawObject_Error:
    Resume DrawObject_Res

End Sub

