VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsADOFieldInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

' bentigte Klassen-Vars
Private mColFieldInfo As Collection
Private cConn As ADODB.Connection

Public Function GetADOFieldInfo(ByVal vConn As ADODB.Connection, _
                                ByVal TableName As String, Optional bTable As Boolean = True, _
                                Optional ByVal ColumnName As String = Empty) As Boolean

Dim cRSTColumnInfo As ADODB.Recordset
Dim cRSTColumnKeys As ADODB.Recordset
Dim cFieldInfo As clsFieldInfo
Dim lTyp As Long

    On Error GoTo GetADOFieldInfo_Err

    ' vConn prfen und Funktion ggf. verlassen
    If vConn Is Nothing Then Exit Function
    Set cConn = vConn

    ' Collection lschen !?!
    ClearCollection

    ' Indizes der Tabelle holen
    Set cRSTColumnKeys = cConn.OpenSchema(adSchemaIndexes, _
                                          Array(Empty, Empty, Empty, Empty, TableName))

    ' Spaltendefinitionen holen
    Set cRSTColumnInfo = cConn.OpenSchema(adSchemaColumns, _
                                          Array(Empty, Empty, TableName, _
                                                IIf(ColumnName <> "", ColumnName, Empty)))

    ' Spaltendefinitionen auswerten und in die Collection bertragen
    With cRSTColumnInfo
        Do While Not .EOF
            If bTable Then
                lTyp = accApp.CurrentDb.TableDefs(TableName).Fields(.Fields("COLUMN_NAME")).Type
            Else
                lTyp = accApp.CurrentDb.QueryDefs(TableName).Fields(.Fields("COLUMN_NAME")).Type
            End If
            ' Item-Klasse instanzieren
            Set cFieldInfo = New clsFieldInfo

            ' Spaltenname ermitteln
            cFieldInfo.FieldName = .Fields("COLUMN_NAME")

            ' Datentype ermitteln (numerisch)
            cFieldInfo.DataTypeNum = lTyp    '.Fields("DATA_TYPE")

            ' DBMS speziefische Variablenbeschreibung ermitteln
            cFieldInfo.DataTypeName = fuFieldTyp(lTyp).tpDeclare    ' GetFieldType(.Fields("DATA_TYPE"))

            ' Hat die Spalte einen Default?
            cFieldInfo.ColumnHasDefaut = .Fields("COLUMN_HASDEFAULT")
            If .Fields("COLUMN_HASDEFAULT") Then
                If Not IsNull(.Fields("COLUMN_DEFAULT")) Then
                    cFieldInfo.ColumnDefault = CStr(.Fields("COLUMN_DEFAULT"))
                End If
            End If

            ' Liegt eine Spaltenbeschreibung vor? (DBMS Speziefisch)
            If Not IsNull(.Fields("DESCRIPTION")) Then _
               cFieldInfo.ColumnDescription = .Fields("DESCRIPTION")

            ' Knnen NULL-Werte in der Spalte gespeichert werden?
            cFieldInfo.IsNullAble = .Fields("IS_NULLABLE")

            ' Die Genauigkeit der numerischen Feldtypen ermitteln
            If Not IsNull(.Fields("NUMERIC_PRECISION")) Then
                cFieldInfo.NumPrecision = Format$ _
                                          (.Fields("NUMERIC_PRECISION"))
                If Not IsNull(.Fields("NUMERIC_SCALE")) Then
                    cFieldInfo.NumPrecision = cFieldInfo.NumPrecision & _
                                              "," & Format$(.Fields("NUMERIC_SCALE"))
                End If
            ElseIf Not IsNull(.Fields("DATETIME_PRECISION")) Then
                cFieldInfo.NumPrecision = Format$ _
                                          (.Fields("DATETIME_PRECISION"))
            End If

            ' Die Lnge der Char-Feldtypen ermitteln
            If Not IsNull(.Fields("CHARACTER_MAXIMUM_LENGTH")) Then
                cFieldInfo.FieldLength = Format$ _
                                         (.Fields("CHARACTER_MAXIMUM_LENGTH"))
            End If

            ' Auf PrimaryKey und Indizes prfen
            '      If cRSTColumnKeys.RecordCount > 0 Then
            '        If Not cRSTColumnKeys.BOF Then cRSTColumnKeys.MoveFirst
            Do While Not cRSTColumnKeys.EOF
                If cFieldInfo.FieldName = cRSTColumnKeys.Fields("COLUMN_NAME") Then
                    cFieldInfo.PrimaryKey = cRSTColumnKeys.Fields("PRIMARY_KEY")
                    cFieldInfo.isIndex = True
                End If
                cRSTColumnKeys.MoveNext
            Loop
            '        End If

            ' Alle Informationen der Spalte in die Collection schieben
            mColFieldInfo.Add cFieldInfo, .Fields("COLUMN_NAME")

            ' Item-Klasse zerstren
            Set cFieldInfo = Nothing

            ' Nchste Spalte...
            .MoveNext
            DoEvents
        Loop
    End With

    cRSTColumnInfo.Close
    GetADOFieldInfo = True
    Exit Function

GetADOFieldInfo_Err:
    GetADOFieldInfo = False
End Function

' DBMS-Speziefische Variablendefinitionen holen
Private Function GetFieldType(ByVal vDataType As Long) As String
Dim cRSTField As ADODB.Recordset

    GetFieldType = "Unknown"
    If Not IsNumeric(vDataType) Then Exit Function

    On Error GoTo GetFieldType_Err

    Set cRSTField = cConn.OpenSchema(adSchemaProviderTypes)
    With cRSTField
        Do While Not .EOF
            If vDataType = CLng(.Fields("DATA_TYPE")) Then
                GetFieldType = .Fields("TYPE_NAME").Value
                Exit Do
            End If
            .MoveNext
        Loop
    End With
    Exit Function

GetFieldType_Err:
    GetFieldType = "Unknown"
End Function

' gesamte Collection rekursiv lschen
Private Sub ClearCollection()
    Do While mColFieldInfo.Count > 0
        mColFieldInfo.Remove 1
        ClearCollection
    Loop
End Sub

' Eigenschaften der Klasse
Public Property Get Count() As Long
    Count = mColFieldInfo.Count
End Property

Public Property Get Item(ByVal Index As Long) As clsFieldInfo
    Set Item = mColFieldInfo(Index)
End Property

Private Sub Remove(ByVal Index As Integer)
    mColFieldInfo.Remove Index
End Sub

Private Sub Class_Initialize()
    Set mColFieldInfo = New Collection
End Sub

Private Sub Class_Terminate()
    Set mColFieldInfo = Nothing
End Sub


