VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cGradient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'   Dieser Source stammt von http://www.activevb.de
'   und kann frei verwendet werden. Fr eventuelle Schden
'   wird nicht gehaftet.
'
'   Um Fehler oder Fragen zu klren, nutzen Sie bitte unser Forum.
'   Ansonsten viel Spa und Erfolg mit diesem Source !
'
'   Autor:  Konrad Rudolph <konrad_rudolph@ActiveVB.de>


Option Explicit

'----------------------------------------------------
' IMPORTANT
'
' because VB doens't accept structs to be passed over
' to classes you have to pass over the RECT structure
' for the position as a long pointer. E.g., instead '
' of writing
'   Call DrawGradient(hDC, Position, colFrom, colTo)
' write:
'   Call DrawGradient(hDC, VarPtr(Position), colFrom, colTo)
'----------------------------------------------------

'----------------------------------------------------
Private Type RECT
    Left            As Long
    Top             As Long
    Right           As Long
    Bottom          As Long
End Type

Private Type BITMAPINFOHEADER
    biSize          As Long
    biWidth         As Long
    biHeight        As Long
    biPlanes        As Integer
    biBitCount      As Integer
    biCompression   As Long
    biSizeImage     As Long
    biXPelsPerMeter As Long
    biYPelsPerMeter As Long
    biClrUsed       As Long
    biClrImportant  As Long
End Type

Private Type RGBQUAD
    rgbBlue         As Byte
    rgbGreen        As Byte
    rgbRed          As Byte
    rgbReserved     As Byte
End Type

Private Type BITMAPINFO
    bmiHeader       As BITMAPINFOHEADER
    bmiColors(255)  As RGBQUAD
End Type

Public Enum GradientDirection
    GD_HORIZONTALLY = 0
    GD_VERICALLY = 1
End Enum

Private Declare Function StretchDIBits Lib "gdi32" ( _
  ByVal hDC As Long, _
  ByVal X As Long, _
  ByVal Y As Long, _
  ByVal dx As Long, _
  ByVal dy As Long, _
  ByVal SrcX As Long, _
  ByVal SrcY As Long, _
  ByVal wSrcWidth As Long, _
  ByVal wSrcHeight As Long, _
  lpBits As Any, _
  lpBitsInfo As BITMAPINFO, _
  ByVal wUsage As Long, _
  ByVal dwRop As Long _
) As Long

Private Declare Sub Peek Lib "kernel32" Alias "RtlMoveMemory" ( _
  nDest As Any, _
  ByVal lpSrc As Long, _
  ByVal nLen As Long _
)

'----------------------------------------------------
' DrawGradient
' draws a gradient on a target
' - Target As Long: hDC of target
' - Position As Long: pointer to a RECT structure indicating where to paint
' - colFrom As OLE_COLOR: starting color
' - colTo As OLE_COLOR: ending color
' - Direction As GradientDirection: horizontally or vertically
'----------------------------------------------------
Public Sub DrawGradient( _
  Target As Long, _
  lpPosition As Long, _
  colFrom As OLE_COLOR, _
  colTo As OLE_COLOR, _
  Optional Direction As GradientDirection = GD_HORIZONTALLY _
)
On Error Resume Next

    Dim Gradient()  As Byte
    Dim Info        As BITMAPINFO
    Dim i           As Long
    Dim Width       As Long, _
        Height      As Long
    Dim StepR       As Single, _
        StepG       As Single, _
        StepB       As Single
    Dim StartR      As Byte, _
        StartG      As Byte, _
        StartB      As Byte
    Dim EndR        As Byte, _
        EndG        As Byte, _
        EndB        As Byte
    Dim CurrentR    As Single, _
        CurrentG    As Single, _
        CurrentB    As Single
    
    Dim Position    As RECT
    
    Call Peek(Position, lpPosition, LenB(Position))
    
    With Position
        Width = .Right - .Left
        Height = .Bottom - .Top
    End With
    
    ' set up bmp header
    With Info.bmiHeader
        .biBitCount = 24
        .biSize = Len(Info.bmiHeader)
        .biPlanes = 1
    End With
    
    ' get start colors
    StartR = colFrom And vbRed
    StartG = (colFrom And vbGreen) \ &H100
    StartB = (colFrom And vbBlue) \ &H10000
    
    ' get end colors
    EndR = colTo And vbRed
    EndG = (colTo And vbGreen) \ &H100
    EndB = (colTo And vbBlue) \ &H10000
    
    CurrentR = StartR
    CurrentG = StartG
    CurrentB = StartB
    
    Select Case Direction
    Case GradientDirection.GD_HORIZONTALLY
        ReDim Gradient(3 * Width - 1) As Byte
        
        ' set up bmp dimensions
        With Info.bmiHeader
            .biWidth = Width
            .biHeight = 1
            .biSizeImage = Width
        End With
        
        ' get step size
        StepR = (CSng(EndR) - CSng(StartR)) / Width
        StepG = (CSng(EndG) - CSng(StartG)) / Width
        StepB = (CSng(EndB) - CSng(StartB)) / Width
        
        ' loop through bitmap and set colors
        For i = 0 To Width - 1
            Gradient(i * 3) = CurrentB
            Gradient(i * 3 + 1) = CurrentG
            Gradient(i * 3 + 2) = CurrentR
        
            CurrentR = CurrentR + StepR
            CurrentG = CurrentG + StepG
            CurrentB = CurrentB + StepB
        Next
        
        ' blit bmp
        Call StretchDIBits(Target, _
          Position.Left, Position.Top, _
          Width, Height, _
          0, 0, Width, 1, Gradient(0), _
          Info, 0, vbSrcCopy)
    
    Case GradientDirection.GD_VERICALLY
        ReDim Gradient(4 * 3 * Height - 1) As Byte
        
        ' set up bmp dimensions
        With Info.bmiHeader
            .biWidth = 4
            .biHeight = Height
            .biSizeImage = Height
        End With
        
        ' get step size
        StepR = (CSng(EndR) - CSng(StartR)) / Height / 4
        StepG = (CSng(EndG) - CSng(StartG)) / Height / 4
        StepB = (CSng(EndB) - CSng(StartB)) / Height / 4
        
        ' loop through bitmap and set colors
        For i = 0 To 4 * Height - 1
            Gradient(i * 3) = CurrentB
            Gradient(i * 3 + 1) = CurrentG
            Gradient(i * 3 + 2) = CurrentR
        
            CurrentR = CurrentR + StepR
            CurrentG = CurrentG + StepG
            CurrentB = CurrentB + StepB
        Next
        
        ' blit bmp
        Call StretchDIBits(Target, _
          Position.Left, Position.Top, _
          Width, Height, _
          0, 0, 4, Height, Gradient(0), _
          Info, 0, vbSrcCopy)
    End Select
End Sub

'----------------------------------------------------
' DrawGradientEx
' draws a multicolor gradient on a target
' - Target As Long: hDC of target
' - Position As Long: pointer to a RECT structure indicating where to paint
' - Colors() As OLE_COLOR: array of all colors to use
' - Direction As GradientDirection: horizontally or vertically
'----------------------------------------------------
Public Sub DrawGradientEx( _
  Target As Long, _
  lpPosition As Long, _
  colors() As OLE_COLOR, _
  Optional Direction As GradientDirection = GD_HORIZONTALLY _
)
 

    Dim Bounds  As Long
    Dim i       As Long
    Dim Diff    As Single
    Dim ActRect As RECT
    
    Dim Position    As RECT
    
    Call Peek(Position, lpPosition, LenB(Position))
    
    Bounds = UBound(colors)
    If LBound(colors) Or Bounds < 1 Then _
        Exit Sub
    
    Select Case Direction
    Case GradientDirection.GD_HORIZONTALLY
        Diff = (Position.Right - Position.Left) / Bounds
        
        With ActRect
            .Left = Position.Left
            .Top = Position.Top
            .Right = .Left + Diff
            .Bottom = Position.Bottom
        End With
        
        For i = 1 To Bounds
            Call DrawGradient(Target, VarPtr(ActRect), _
              colors(i - 1), colors(i), Direction)
            With ActRect
                .Left = .Left + Diff
                .Right = .Right + Diff
            End With
        Next
    Case GradientDirection.GD_VERICALLY
        Diff = (Position.Bottom - Position.Top) / Bounds
        
        ' goes from bottom to top!
        With ActRect
            .Left = Position.Left
            .Bottom = Position.Bottom
            .Right = Position.Right
            .Top = .Bottom - Diff
        End With
        
        For i = 1 To Bounds
            Call DrawGradient(Target, VarPtr(ActRect), _
              colors(i - 1), colors(i), Direction)
            With ActRect
                .Top = .Top - Diff
                .Bottom = .Bottom - Diff
            End With
        Next
    End Select
End Sub




